<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>{{ __('Invoice') }} | {{ env('APP_NAME') }}</title>
  <meta name="csrf-token" content="{{ csrf_token() }}"><!-- CSRF Token -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <!-- Fonts -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

  <!-- Styles -->
  <link href="{{ asset('css/font-awesome.min.css') }}" rel="stylesheet" type="text/css"/>
  <link rel="stylesheet" href="{{ asset('css/admin.css') }}">
</head>
<body class="hold-transition skin-blue sidebar-mini" style="background: #111">

@if (isset($invoice) && $invoice != null)
<section id="main-wrapper" class="main-wrapper invoice">
    <div id="printableArea">
        <div class="container">
            <div class="panel-body">

                @php
                    $setting = App\Config::first();

                    // Determine the base price (offer_price if valid, else price)
                    $basePrice = ($invoice->offer_price && $invoice->offer_price > 0) ? $invoice->offer_price : $invoice->price;

                    // GST percentage (default 0)
                    $gstPercent = $invoice->gst ?? 0;

                    // Calculate GST amount based on basePrice
                    $gstAmount = $gstPercent > 0 ? ($basePrice * $gstPercent) / 100 : 0;

                    // Amount without GST
                    $amount = $basePrice;

                    // Final price including GST
                    $finalPrice = $basePrice + $gstAmount;
                @endphp

                <div class="invoice-logo mb-3">
                    @if($setting && $setting->logo)
                        <img src="{{ asset('images/logo/'.$setting->logo) }}" class="img-fluid" alt="{{ $setting->title ?? 'Logo' }}">
                    @else
                        <a href="{{ url('/') }}">
                            <b><div class="logotext">{{ $setting->title ?? env('APP_NAME') }}</div></b>
                        </a>
                    @endif
                </div>

                <p class="total-heading">{{ __('Purchased on') }}: {{ date('jS F Y', strtotime($invoice->created_at)) }}</p>
                <hr/>

                <div class="row mb-4">
                    <div class="col-12 col-md-4">
                        <b>{{ __('From') }}:</b>
                        <address>
                            <strong>{{ $gst->company_name ?? '' }}</strong><br>
                            {!! $invoice_add ?? '' !!} <br>
                            {{ __('GST Number') }}: {{ $gst->gst_number ?? '' }}<br>
                            {{ __('Address') }}: {{ $gst->address ?? '' }}
                        </address>
                    </div>

                    <div class="col-12 col-md-4">
                        <b>{{ __('To') }}:</b>
                        <address>
                            <strong>{{ auth()->user()->name }}</strong><br>
                            {{ __('Email') }}: {{ auth()->user()->email }}
                        </address>
                    </div>

                    <div class="col-12 col-md-4">
                        <b>{{ __('Invoice') }}:</b> #{{ $invoice->id }}<br>
                        <b>{{ __('Order ID') }}:</b> {{ $invoice->payment_id }}<br>
                        <b>{{ __('Payment Mode') }}:</b> {{ ucfirst($invoice->payment_type) }}
                    </div>
                </div>

                <div class="row">
                    <div class="col-12 table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('User Name') }}</th>
                                    <th>{{ __('Movie/Series Name') }}</th>
                                    <th>{{ __('Method') }}</th>
                                    <th>{{ __('Line Total') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>{{ auth()->user()->name }}</td>
                                    <td>
                                        {{ $invoice->movie->title ?? '' }}{{ $invoice->tvseries->title ?? '' }}
                                    </td>
                                    <td>{{ ucfirst($invoice->payment_type) }}</td>
                                    <td>
                                        @if($invoice->offer_price && $invoice->offer_price > 0)
                                            <div><b>{{ __('Original Price') }}:</b> <del>{{ $converted_symbol }} {{ number_format($invoice->price, 2) }}</del></div>
                                            <div><b>{{ __('Offer Price') }}:</b> {{ $converted_symbol }} {{ number_format($invoice->offer_price, 2) }}</div>
                                        @endif

                                        <div><b>{{ __('Total') }}:</b> {{ $converted_symbol }} {{ number_format($finalPrice, 2) }}</div>

                                        @if($gstPercent > 0)
                                            <small>
                                                ({{ __('Base') }}: {{ $converted_symbol }}{{ number_format($amount, 2) }} + {{ $gstPercent }}% GST = {{ strtoupper($currency_code) }}{{ number_format($gstAmount, 2) }})
                                            </small>
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row my-4">
                    <div class="col-12">
                        <p class="lead">{{ __('Payment Methods') }}:</p>
                        <img src="{{ url('images/credit/visa.png') }}" alt="Visa" style="max-height: 30px; margin-right: 10px;">
                        <img src="{{ url('images/credit/mastercard.png') }}" alt="Mastercard" style="max-height: 30px; margin-right: 10px;">
                        <img src="{{ url('images/credit/american-express.png') }}" alt="American Express" style="max-height: 30px; margin-right: 10px;">
                        <img src="{{ url('images/credit/paypal2.png') }}" alt="Paypal" style="max-height: 30px; margin-right: 10px;">
                    </div>
                </div>

                <div class="printbox col-12 text-justify mt-3">
                    <hr>
                    {{ __('This is a computer-generated invoice and does not require a physical signature.') }}<br>
                    {{ __('If you have any questions concerning this invoice, feel free to write to us at our email address.') }}
                </div>
            </div>
        </div>
    </div>

    <div class="print-btn my-3" style="margin-left: 25px;">
        <input type="button" class="btn btn-primary" onclick="printDiv('printableArea')" value="{{ __('Print') }}">
    </div>
</section>
@endif

<script src="{{ asset('js/jquery.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('js/admin.js') }}" type="text/javascript"></script>

<script type="text/javascript">
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;

        window.print();

        document.body.innerHTML = originalContents;
    }
</script>

</body>
</html>
